/************************************************************************
 * NAME:	fs-trs8034.h
 *
 * DESCR:	Defines the calls for the model 3/4 filesystem, which end
 *		up just calling the generic TRS80 stuff.
 *
 * NOTES:	
 ************************************************************************/

/* this must be exactly the same as the trs80 structure! */

struct fs_trs8034 {
    struct floppy	*floppy;
    int			isTRSDOS23;
    int			dirtrack;	/* which track has the directory */
};

int	fs_trs8034_init(struct floppy *,struct fs_trs8034 *);
int	fs_trs8034_add(struct fs_trs8034 *, char *, int);
int	fs_trs8034_delete(struct fs_trs8034 *, char *);
int	fs_trs8034_report(struct fs_trs8034 *, int);
int	fs_trs8034_extract(struct fs_trs8034 *, char *, int);
int	fs_trs8034_cleanup(struct fs_trs8034 *);
char	*fs_trs8034_description(void);

